import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:google_fonts/google_fonts.dart';

import '../../services/app_service.dart';
import '../../utils/toast.dart';

class CodePreview extends StatelessWidget {
  const CodePreview({
    super.key,
    required this.data,
  });

  final String data;

  Future<void> _copyToClipboard(BuildContext context, String text) async {
    await Clipboard.setData(ClipboardData(text: text));
    openToast('Code copied to clipboard');
  }

  @override
  Widget build(BuildContext context) {
    final normalizedText = AppService.getNormalText(data);

    return Padding(
      padding: const EdgeInsets.symmetric(vertical: 10, horizontal: 20),
      child: Stack(
        children: [
          Container(
            color: Theme.of(context).colorScheme.surfaceContainerHighest,
            width: double.infinity,
            padding: const EdgeInsets.all(15),
            child: SelectableText(
              normalizedText,
              style: GoogleFonts.robotoMono(
                fontSize: 16,
                fontWeight: FontWeight.normal,
                color: Theme.of(context).colorScheme.onSurface,
              ),
            ),
          ),
          Positioned(
            top: 8,
            right: 8,
            child: Material(
              color:
                  Theme.of(context).colorScheme.surface.withValues(alpha: 0.9),
              borderRadius: BorderRadius.circular(8),
              child: InkWell(
                onTap: () => _copyToClipboard(context, normalizedText),
                borderRadius: BorderRadius.circular(8),
                child: Padding(
                  padding: const EdgeInsets.all(8),
                  child: Icon(
                    Icons.copy,
                    size: 18,
                    color: Theme.of(context).colorScheme.onSurface,
                  ),
                ),
              ),
            ),
          ),
        ],
      ),
    );
  }
}
